/* Ref FG Banner — League-only, outputs PNG sequence per team (Tint FG-Text to Primary) */
(function () {
  // --- load common helpers (force reload) ---
  (function(){
    var COMMON = $.getenv("AE_COMMON_JSX") || "";
    if (COMMON) { try { delete $.global.GL; } catch(e) { $.global.GL = undefined; } $.evalFile(File(COMMON)); }
    if (!$.global.GL) throw new Error("Common library not loaded. Set AE_COMMON_JSX to gl_common.jsxinc");
  })();

  var GL = $.global.GL;

  // --- env ---
  var PROJECT   = GL.env("AE_PROJECT", null);
  var CSV_PATH  = GL.env("AE_CSV", null);
  var COMP_NAME = GL.env("AE_COMP","FG Comp");

  // Layer names (override via env if needed)
  var SIMPLESTREAK_LAYER = GL.env("AE_SIMPLESTREAK_LAYER","SimpleStreak");
  var TEAMABBREV_LAYER   = GL.env("AE_TEAMABBREV_LAYER","TeamAbbrev");
  var FIELDGOAL_LAYER    = GL.env("AE_FIELDGOAL_LAYER","FG-Text"); // <-- UPDATED default
  var LOGO_LAYER         = GL.env("AE_LOGO_LAYER","TeamLogo");

  var LEAGUE    = GL.env("AE_LEAGUE","");
  var LIMIT_STR = GL.env("AE_LIMIT","");
  var LIMIT     = (LIMIT_STR && !isNaN(parseInt(LIMIT_STR,10))) ? parseInt(LIMIT_STR,10) : null;

  var OUTDIR    = GL.env("AE_OUTDIR","");
  var PATH_TPL  = GL.env("AE_PATH_TEMPLATE","{league}");
  var ANIM_NAME = GL.env("AE_ANIM","_FG_1_3");
  var RS_TPL    = GL.env("AE_RS_TEMPLATE","Best Settings");
  var OM_TPL    = GL.env("AE_OM_TEMPLATE","PNG Sequence");
  var PURGE     = (GL.env("AE_PURGE_BEFORE_RENDER","1")==="1");
  var NO_RENDER = (GL.env("AE_NO_RENDER","0")==="1");
  var QUIT_APP  = (GL.env("AE_QUIT","1")==="1");

  // --- start ---
  if (app.beginSuppressDialogs){ try{ app.beginSuppressDialogs(); }catch(e){} }
  app.beginUndoGroup("Ref FG - League Only - PNG Seq");

  if(!PROJECT) GL.fail("AE_PROJECT env not set.");
  var aep=new File(PROJECT); if(!aep.exists) GL.fail("AE_PROJECT not found: "+PROJECT);
  app.open(aep);

  if(!CSV_PATH) GL.fail("AE_CSV env not set.");
  if(!LEAGUE || GL.cleanValue(LEAGUE)==="") GL.fail("AE_LEAGUE is required.");

  var rows   = GL.parseCSV(GL.openRead(CSV_PATH));
  var teams  = GL.buildTeams(rows, LEAGUE);             // includes espn_team_id if present
  var todo   = GL.pickTeamsLeagueOnly(teams, LEAGUE);
  if (LIMIT && todo.length>LIMIT) todo = todo.slice(0, LIMIT);
  if(!todo.length) GL.fail("No teams matched league: "+LEAGUE);

  var comp = GL.findComp(COMP_NAME);
  if(!comp) GL.fail("Comp not found: "+COMP_NAME);

  var rootOut = OUTDIR ? new Folder(OUTDIR) : (app.project.file ? app.project.file.parent : Folder.desktop);
  GL.ensureFolder(rootOut);

  var logoOpts = {
    dir: GL.env("AE_LOGO_DIR",""),
    tpl: GL.env("AE_LOGO_PATH_TEMPLATE","{league}/{abbr}"),
    exts: GL.env("AE_LOGO_EXTS","png,jpg,jpeg,svg,ai,psd")
  };

  GL.rqClear();

  // --- helpers specific to this comp ---
  function tintSimpleStreakToPrimary(compItem, color01){
    var streak = GL.getLayerAlt(compItem, SIMPLESTREAK_LAYER, ["SimpleSteak"]);
    if (!streak) return 0;
    return GL.setTintBothColorsDeep(streak, color01, /*forceAmount100*/ true, /*depth*/ 0);
  }

  // EXACT layer tint (for FG-Text): add Tint if missing, set both colors to Primary, Amount=100
  function tintFGTextToPrimary(compItem, color01){
    var ly = GL.getLayerAlt(compItem, FIELDGOAL_LAYER, ["FIELDGOAL","FIELD GOAL","Field Goal","FGText","FG_Text"]);
    if (!ly) return 0;
    return GL.setTintBothColors(ly, color01, /*forceAmount100*/ true);
  }

  function setTeamAbbrev(compItem, abbr, color01){
    var ly = GL.getLayerAlt(compItem, TEAMABBREV_LAYER, ["TeamAbbrec"]);
    if (!ly) return false;
    GL.setTextContent(ly, abbr);
    return GL.setTextOrFillColor(ly, color01);
  }

  // --- per team ---
  for (var i=0;i<todo.length;i++){
    var t = todo[i];

    var smart  = GL.computeSmartColors( GL.safeColor(t.primary), GL.safeColor(t.secondary) );
    var P = smart.primary;   // PRIMARY for both Map-To colors
    var S = smart.secondary;

    // 1) Streak tint = PRIMARY
    tintSimpleStreakToPrimary(comp, P);

    // 2) Logo replace
    GL.replaceLogo(comp, LOGO_LAYER, t.league, t.abbr, logoOpts);

    // 3) FG-Text (single layer with Tint) → PRIMARY
    tintFGTextToPrimary(comp, S);

    // 4) TeamAbbrev text/fill = PRIMARY
    setTeamAbbrev(comp, t.abbr, P);

    if (PURGE && app.purge) { try{ app.purge(PurgeTarget.ALL_CACHES); }catch(e){} }

    if (!NO_RENDER){
      var lc = GL.leagueAndConfForPath(t.league, t.conference);
      var paths = GL.outPaths(rootOut, PATH_TPL, lc.base, t.abbr, ANIM_NAME, lc.conf, t.espn_team_id);
      GL.snapCompTextForPixelArt(comp);
      GL.rqRenderTo(comp, RS_TPL, OM_TPL, paths.file);
    }
  }

  app.endUndoGroup();
  if (app.endSuppressDialogs){ try{ app.endSuppressDialogs(); }catch(e){} }
  if (QUIT_APP) app.quit();
})();
